<?php
include 'koneksi.php';
include 'header1.php';

// **1. Retrieve Data from Database**
$query_alternatif = mysqli_query($conn, "SELECT * FROM mahasiswa");
$nilai_alternatif = [];
while ($row = mysqli_fetch_assoc($query_alternatif)) {
    $nilai_alternatif[] = $row;
}

// **2. Criteria Names Definition**
$kriteria_nama = [
    "c1" => "Content Relevance",
    "c2" => "Presentation Quality",
    "c3" => "Audiovisual Quality",
    "c4" => "Interactivity & Engagement",
    "c5" => "Frequency of Use",
    "c6" => "Access Barriers",
    "c7" => "Impact on Understanding"
];

// **3. Calculate Average Score per Alternative**
$rata_per_alternatif = [];
$total_rata_rata = 0;
$total_alternatif = count($nilai_alternatif);

foreach ($nilai_alternatif as $alt) {
    $total_nilai = 0;
    $jumlah_kriteria = count($kriteria_nama);
    
    foreach ($kriteria_nama as $key => $nama) {
        $total_nilai += $alt[$key];
    }
    
    $rata_rata = $total_nilai / $jumlah_kriteria;
    $rata_per_alternatif[] = [
        "alternatif" => $alt["alternatif"],
        "rata_rata" => $rata_rata
    ];
    
    $total_rata_rata += $rata_rata;
}

// **4. Calculate Overall Average Score for All Alternatives**
$total_rata_rata /= $total_alternatif;
?>

<style>
    /* Ensure the main container is flexible */
    #layoutSidenav {
        display: flex;
        transition: all 0.3s ease-in-out;
    }

    #layoutSidenav_content {
        flex-grow: 1;
        transition: all 0.3s ease-in-out;
    }

    /* Ensure the table is flexible */
    .table-responsive {
        width: 100%;
        transition: all 0.3s ease-in-out;
    }

    /* If the sidebar is closed, the main container expands */
    body.sb-sidenav-toggled #layoutSidenav_content {
        margin-left: 0;
        width: calc(100% - 0px);
    }

    /* Ensure the table expands as well */
    body.sb-sidenav-toggled .table-responsive {
        width: 100%;
    }
</style>

<div id="layoutSidenav_content">
    <main>
        <div class="container-fluid mt-4">
            <h2 class="text-center mb-4 py-3 bg-light rounded"><strong>AVERAGE SCORE ANALYSIS OF ALTERNATIVES</strong></h2>

            <!-- **Student/Alternative Scores Table** -->
            <div class="card shadow-sm w-100">
                <div class="card-header bg-primary text-white text-center">
                    <h4><i class="fas fa-clipboard-list"></i>  Student Scores Data</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered text-center w-100">
                            <thead class="table-primary">
                                <tr>
                                    <th>Number</th>
                                    <th>Alternative Name</th>
                                    <?php foreach ($kriteria_nama as $key => $nama) : ?>
                                        <th><?= $nama; ?></th>
                                    <?php endforeach; ?>
                                </tr>
                            </thead>
                            <tbody class="table-light">
                                <?php $no = 1; ?>
                                <?php foreach ($nilai_alternatif as $row) : ?>
                                    <tr>
                                        <td><?= $no++; ?></td>
                                        <td><?= htmlspecialchars($row["alternatif"]); ?></td>
                                        <?php foreach ($kriteria_nama as $key => $nama) : ?>
                                            <td><?= number_format($row[$key], 0); ?></td>
                                        <?php endforeach; ?>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <br><br>

            <!-- **Average Score Analysis Table** -->
            <div class="card shadow-sm w-100">
                <div class="card-header bg-parimary text-white text-center">
                    <h4><i class="fas fa-chart-line"></i> Average Scores</h4>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-bordered text-center w-100">
                            <thead class="table-primary">
                                <tr>
                                    <th>Number</th>
                                    <th>Alternative Name</th>
                                    <th>Average Score</th>
                                </tr>
                            </thead>
                            <tbody class="table-light">
                                <?php $no = 1; ?>
                                <?php foreach ($rata_per_alternatif as $alt) : ?>
                                    <tr>
                                        <td><?= $no++; ?></td>
                                        <td><?= htmlspecialchars($alt["alternatif"]); ?></td>
                                        <td><?= number_format($alt["rata_rata"], 2); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                            <tfoot class="table-dark">
                                <tr>
                                    <th colspan="2" class="text-center">Total Average Score for All Alternatives</th>
                                    <th><?= number_format($total_rata_rata, 2); ?></th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>

            <br><br>

            <!-- **Analysis Conclusion** -->
            <div class="text-center">
                <h4>Average Score Conclusion</h4>
            </div>
            <div class="card-body">
                <p class="text-justify" style="font-size: 18px;">
                    Based on the calculation of the average score for alternatives, the overall average score for all students is 
                    <b style="color: red;"><?= number_format($total_rata_rata, 2); ?></b>. 
                    This result indicates that YouTube's effectiveness as a learning medium for Computer Science students is relatively high.
                </p>

                <p class="text-justify" style="font-size: 18px;">
                    If this average score is above <b>75</b>, it can be concluded that YouTube is generally an effective learning medium. 
                    However, this result is still general and not sufficient for a final conclusion. Therefore, further calculations using the Weighted Product (WP) method are necessary
                    to obtain more objective results that consider the weights of each criterion in the learning effectiveness assessment.
                </p>

                <p class="text-justify" style="font-size: 18px;">
                    With the WP method, we can determine the most optimal final score based on the weighted criteria. 
                    This process will provide more accurate recommendations for selecting the best learning resources on YouTube for Computer Science students.
                </p>
                <br><br>

                <!-- Button to Start WP Calculation -->
                <div class="text-center">
                    <a href="proses1.php" class="btn btn-lg btn-outline-primary">
                        <i class="fas fa-calculator"></i> Start Weighted Product Calculation
                    </a>
                </div>
            </div>

            <br><br>
        </div>
    </main>
</div>

<!-- 🔥 JavaScript for Sidebar Toggle -->
<script>
    document.addEventListener("DOMContentLoaded", function () {
        let sidebarToggle = document.querySelector("#sidebarToggle");
        sidebarToggle.addEventListener("click", function () {
            document.body.classList.toggle("sb-sidenav-toggled");
        });
    });
</script>
